package gov.va.med.mhv.phr.allergy.decorator;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.phr.decorator.DecoratorUtils;
import gov.va.med.mhv.phr.transfer.Allergy;
import gov.va.med.mhv.phr.transfer.ImpreciseDateComposite;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.messages.Message;
import org.tigris.atlas.messages.MessageFactory;
import org.tigris.atlas.messages.Messages;


/*
 * Decorator for Allergy Details page
 */
public class AllergyDecorator implements Serializable {

	private static final long serialVersionUID = 1L;
	
    private static final Log LOG = LogFactory.getLog(
    		AllergyTableDecorator.class); 	
	
	private Allergy allergyRecord;
	private gov.va.med.mhv.healthhistory.transfer.Allergy seiAllergyRecord;
    private final ArrayList<Allergy> tests = new ArrayList<Allergy>();
    private Messages messages;
    
    protected static final String UNKNOWN = 
        StringEscapeUtils.escapeHtml("Unknown");    
    
    protected static final String VA = 
        StringEscapeUtils.escapeHtml("VA");
    
    protected static final String SELF = 
        StringEscapeUtils.escapeHtml("Self");     

    
    @SuppressWarnings("unchecked")
    public AllergyDecorator(Allergy allergyRecord) {
        Precondition.assertNotNull("allergyRecord", allergyRecord);
        this.allergyRecord = allergyRecord;
    }
     

	@SuppressWarnings("unchecked")
    public AllergyDecorator(gov.va.med.mhv.healthhistory.transfer.Allergy seiAllergyRecord) {
        Precondition.assertNotNull("seiAllergyRecord", seiAllergyRecord);
        this.seiAllergyRecord = seiAllergyRecord;
    }    
    
    
    public String getCollectedOn() {
    	if(allergyRecord!=null){
	        ImpreciseDateComposite observationDate = allergyRecord.getObservationDateComposite();
	        if (observationDate == null){
	            return UNKNOWN;
	        } else if (observationDate.getValue() != null){
	        	return DecoratorUtils.formatDate(observationDate);
	        }  
	        else if (observationDate.getImpreciseValue()!=null){
	        	return observationDate.getImpreciseValue();
	        }
	        else{
	        	return UNKNOWN;
	        }
    	}else{
    		return "";
    	}
    	
    }

    public String getFacilityName() {
    	if(allergyRecord!=null && allergyRecord.getFacilityInfo()!=null){
    		return DecoratorUtils.escapedValueOrUnknown(allergyRecord.getFacilityInfo());
		}else{
	    	return "";
	    }        
    }    

	public String getReactant() {
		if(allergyRecord!=null && allergyRecord.getReactant()!=null){		
	        String reactant = allergyRecord.getReactant();
	        return DecoratorUtils.escapedValueOrUnknown(reactant);
		}else{
        	return "";
        }        
    }
	
    public String getAllergyReaction() {
    	if(allergyRecord!=null && allergyRecord.getReaction()!=null){
    		return DecoratorUtils.escapedValueOrUnknown(allergyRecord.getReaction());
        }else{
        	return "";
        }
    }
    
    public String getAllergyDrugClass() {
    	if(allergyRecord!=null && allergyRecord.getDrugClass()!=null){
    		return DecoratorUtils.escapedValueOrUnknown(allergyRecord.getDrugClass());
        }else{
        	return "";
        }
    }
    
    public String getAllergyComments() {
    	if(allergyRecord!=null && allergyRecord.getComments()!=null){
    		return DecoratorUtils.escapedValueOrUnknown(allergyRecord.getComments());
        }else{
        	return "";
        }
    }    
    
    public String getAllergyType() {
    	if(allergyRecord!=null && allergyRecord.getAllergyType()!=null){    	
    		return DecoratorUtils.escapedValue(allergyRecord.getAllergyType());
        }else{
        	return "";
        }        
    }
    
    public String getAllergySource() {
    	if(allergyRecord!=null && allergyRecord.getAllergyType()!=null){
        	return VA;
        }else{
            return SELF;
        }
    }    
    
    public String getObserved() {
    	if(allergyRecord!=null && allergyRecord.getObserved()!=null){    	
    		return DecoratorUtils.escapedValue(allergyRecord.getObserved());
        }else{
        	return "";
        }    		
    }    
    
    public Long getId() {
    	return allergyRecord.getId();
    }

    public List<Allergy> getTests() {
        return tests;
    }

    public Messages getMessages() {
        return messages;
    }

    public void clearMessages() {
    	messages = MessageFactory.createMessages();
    }
    
    public void clearMessages(String key) {
    	Messages newMessages = MessageFactory.createMessages();
    	Collection msgs = new ArrayList();
    	msgs.addAll(this.messages.getErrorMessages());
    	msgs.addAll(this.messages.getInformationalMessages());
    	for(Object o : msgs) {
    		Message m = (Message)o;
    		if ( ! m.getKey().equals(key)) {
    			newMessages.addMessage(m);
    		}
    	}
    	this.messages = newMessages;
    }
    
    
    /**
     * SEI Allergy detailed view
     */
    public String getSEIAllergyRecord() {
    	if(!StringUtils.isEmpty(seiAllergyRecord.getAllergy())){  	
    		return DecoratorUtils.escapedValueOrUnknown(seiAllergyRecord.getAllergy());
    	}else{
    		return "";
    	}
    }

    public String getSEIAllergySeverity() {
    	if(null != seiAllergyRecord.getSeverity() && !StringUtils.isEmpty(seiAllergyRecord.getSeverity().getName())){
    		String sevName = seiAllergyRecord.getSeverity().getName();    		
    		if(sevName.equals("L")){
    			return "Mild";
    		}else if(sevName.equals("S")){
    			return "Severe";
    		}else if(sevName.equals("M")){
    			return "Moderate";
    		}else{
    			return "";
    		}
    	}else{
    		return "";
    	}
    }
    
    public String getSEIAllergyDiagnosed() {
    	if(null != seiAllergyRecord.getDiagnosed() && !StringUtils.isEmpty(seiAllergyRecord.getDiagnosed().getName())){
    		String diagName = seiAllergyRecord.getDiagnosed().getName();
    		if(diagName.equals("Y")){
    			return "Yes";
    		}else if(diagName.equals("N")){
    			return "No";
    		}else{
    			return "";
    		}
    	}else{
    		return "";
    	}
    }    

    public String getSEIAllergyDate() {
    	Date value = new Date(seiAllergyRecord.getEventDate().getTime());
        return DecoratorUtils.formatDate(value);
    }
    
    public Date getSEICollectedOnDate() {
    	return new Date(seiAllergyRecord.getEventDate().getTime());
    }    
    
    public String getSEISource() {
           return SELF;
    }
    
    public String getSEIAllergyReaction() {
    	if(!StringUtils.isEmpty(seiAllergyRecord.getReaction())){  	
    		return DecoratorUtils.escapedValueOrUnknown(seiAllergyRecord.getReaction());
    	}else{
    		return "";
    	}
    }
    
    public String getSEIAllergyComments() {
    	if(!StringUtils.isEmpty(seiAllergyRecord.getComments())){  	
    		return DecoratorUtils.escapedValueOrUnknown(seiAllergyRecord.getComments());
    	}else{
    		return "";
    	}
    }    
    
}
